<?php
/**
 * Простой JSON API для Telegram-бота
 * Путь: wp-content/plugins/ts3-viewer/ts3-viewer-api.php
 */

// --- НАСТРОЙКИ БЕЗОПАСНОСТИ ---
$secret = 'ТВОЙ_КЛЮЧ'; // владелец сайта меняет на свой

// Проверяем ключ в запросе: ?key=...
if (!isset($_GET['key']) || $_GET['key'] !== $secret) {
    http_response_code(403);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'ok'    => false,
        'error' => 'forbidden',
        'msg'   => 'Invalid or missing key'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// --- ЗАГРУЖАЕМ WORDPRESS (если файл вызывается напрямую) ---
if (!defined('ABSPATH')) {
    $wp_load = dirname(__FILE__, 4) . '/wp-load.php';
    if (file_exists($wp_load)) {
        require_once $wp_load;
    } else {
        http_response_code(500);
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode([
            'ok'    => false,
            'error' => 'wp_load_not_found',
            'msg'   => 'Cannot locate wp-load.php'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
}

// На случай, если плагин ещё не подгружен
if (!function_exists('ts3viewer_get_data_api')) {
    $plugin_file = __DIR__ . '/ts3-viewer.php';
    if (file_exists($plugin_file)) {
        require_once $plugin_file;
    }
}

// Если даже после этого функции нет — ошибка
if (!function_exists('ts3viewer_get_data_api')) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'ok'    => false,
        'error' => 'api_function_missing',
        'msg'   => 'Function ts3viewer_get_data_api() not found'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// --- ПОЛУЧАЕМ ДАННЫЕ О TS3 И ОТДАЁМ JSON ---

$data = ts3viewer_get_data_api();

if (!is_array($data)) {
    $data = [
        'ok'    => false,
        'error' => 'bad_response',
        'msg'   => 'ts3viewer_get_data_api() did not return array'
    ];
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
